import math as m

P2D = "P2D"
P3D = "P3D"

# rect mode
CENTER = "CENTER"
CORNER = "CORNER"

# translation and rotation behavior
RESET = "RESET"
KEEP = "KEEP"

# shapes
RECTANGLE = "RECTANGLE"
ELLIPSE = "ELLIPSE"
CROSS = "CROSS"
PLUS = "PLUS"
CIRCLE = "CIRCLE"
SQUARE = "SQUARE"

# keys behavior
PRESSED = "PRESSED"
RELEASED = "RELEASED"
HOLD = "HOLD"

# menus sides
LEFT = "LEFT"
RIGHT = "RIGHT"

# some math
E = m.e
PI = m.pi
TWO_PI = 2 * PI
HALF_PI = PI / 2
QUARTER_PI = PI / 4
TAU = m.tau

# colors
COLORS: dict[str, tuple[int, int, int]] = {
    "black": (0, 0, 0),
    "navy blue": (0, 0, 128),
    "dark blue": (0, 0, 200),
    "blue": (0, 0, 255),
    "stratos": (0, 7, 65),
    "swamp": (0, 27, 28),
    "resolution blue": (0, 35, 135),
    "deep fir": (0, 41, 0),
    "burnham": (0, 46, 32),
    "international klein blue": (0, 47, 167),
    "prussian blue": (0, 49, 83),
    "midnight blue": (0, 51, 102),
    "smalt": (0, 51, 153),
    "deep teal": (0, 53, 50),
    "cyprus": (0, 62, 64),
    "kaitoke green": (0, 70, 32),
    "cobalt": (0, 71, 171),
    "crusoe": (0, 72, 22),
    "sherpa blue": (0, 73, 80),
    "endeavour": (0, 86, 167),
    "camarone": (0, 88, 26),
    "science blue": (0, 102, 204),
    "blue ribbon": (0, 102, 255),
    "tropical rain forest": (0, 117, 94),
    "allports": (0, 118, 163),
    "deep cerulean": (0, 123, 167),
    "lochmara": (0, 126, 199),
    "azure radiance": (0, 127, 255),
    "teal": (0, 128, 128),
    "bondi blue": (0, 149, 182),
    "pacific blue": (0, 157, 196),
    "persian green": (0, 166, 147),
    "jade": (0, 168, 107),
    "caribbean green": (0, 204, 153),
    "robin's egg blue": (0, 204, 204),
    "green": (0, 255, 0),
    "spring green": (0, 255, 127),
    "cyan": (0, 255, 255),
    "aqua": (0, 255, 255),
    "blue charcoal": (1, 13, 26),
    "midnight": (1, 22, 53),
    "holly": (1, 29, 19),
    "daintree": (1, 39, 49),
    "cardin green": (1, 54, 28),
    "county green": (1, 55, 26),
    "astronaut blue": (1, 62, 98),
    "regal blue": (1, 63, 106),
    "aqua deep": (1, 75, 67),
    "orient": (1, 94, 133),
    "blue stone": (1, 97, 98),
    "fun green": (1, 109, 57),
    "pine green": (1, 121, 111),
    "blue lagoon": (1, 121, 135),
    "deep sea": (1, 130, 107),
    "green haze": (1, 163, 104),
    "english holly": (2, 45, 21),
    "sherwood green": (2, 64, 44),
    "congress blue": (2, 71, 142),
    "evening sea": (2, 78, 70),
    "bahama blue": (2, 99, 149),
    "observatory": (2, 134, 111),
    "cerulean": (2, 164, 211),
    "tangaroa": (3, 22, 60),
    "green vogue": (3, 43, 82),
    "mosque": (3, 106, 110),
    "midnight moss": (4, 16, 4),
    "black pearl": (4, 19, 34),
    "blue whale": (4, 46, 76),
    "zuccini": (4, 64, 34),
    "teal blue": (4, 66, 89),
    "deep cove": (5, 16, 64),
    "gulf blue": (5, 22, 87),
    "venice blue": (5, 89, 137),
    "watercourse": (5, 111, 87),
    "catalina blue": (6, 42, 120),
    "tiber": (6, 53, 55),
    "gossamer": (6, 155, 129),
    "niagara": (6, 161, 137),
    "tarawera": (7, 58, 80),
    "jaguar": (8, 1, 16),
    "black bean": (8, 25, 16),
    "deep sapphire": (8, 37, 103),
    "elf green": (8, 131, 112),
    "bright turquoise": (8, 232, 222),
    "downriver": (9, 34, 86),
    "palm green": (9, 35, 15),
    "madison": (9, 37, 93),
    "bottle green": (9, 54, 36),
    "deep sea green": (9, 88, 89),
    "salem": (9, 127, 75),
    "black russian": (10, 0, 28),
    "dark fern": (10, 72, 13),
    "japanese laurel": (10, 105, 6),
    "atoll": (10, 111, 117),
    "cod gray": (11, 11, 11),
    "marshland": (11, 15, 8),
    "gordons green": (11, 17, 7),
    "black forest": (11, 19, 4),
    "san felix": (11, 98, 7),
    "malachite": (11, 218, 81),
    "ebony": (12, 11, 29),
    "woodsmoke": (12, 13, 15),
    "racing green": (12, 25, 17),
    "surfie green": (12, 122, 121),
    "blue chill": (12, 137, 144),
    "black rock": (13, 3, 50),
    "bunker": (13, 17, 23),
    "aztec": (13, 28, 25),
    "bush": (13, 46, 28),
    "cinder": (14, 14, 24),
    "firefly": (14, 42, 48),
    "torea bay": (15, 45, 158),
    "vulcan": (16, 18, 29),
    "green waterloo": (16, 20, 5),
    "eden": (16, 88, 82),
    "arapawa": (17, 12, 108),
    "ultramarine": (18, 10, 143),
    "elephant": (18, 52, 71),
    "jewel": (18, 107, 64),
    "diesel": (19, 0, 0),
    "asphalt": (19, 10, 6),
    "blue zodiac": (19, 38, 77),
    "parsley": (19, 79, 25),
    "nero": (20, 6, 0),
    "tory blue": (20, 80, 170),
    "bunting": (21, 31, 76),
    "denim": (21, 96, 189),
    "genoa": (21, 115, 107),
    "mirage": (22, 25, 40),
    "hunter green": (22, 29, 16),
    "big stone": (22, 42, 64),
    "celtic": (22, 50, 34),
    "timber green": (22, 50, 44),
    "gable green": (22, 53, 49),
    "pine tree": (23, 31, 4),
    "chathams blue": (23, 85, 121),
    "deep forest green": (24, 45, 9),
    "blumine": (24, 88, 122),
    "palm leaf": (25, 51, 14),
    "nile blue": (25, 55, 81),
    "fun blue": (25, 89, 168),
    "lucky point": (26, 26, 104),
    "mountain meadow": (26, 179, 133),
    "tolopea": (27, 2, 69),
    "haiti": (27, 16, 53),
    "deep koamaru": (27, 18, 123),
    "acadia": (27, 20, 4),
    "seaweed": (27, 47, 17),
    "biscay": (27, 49, 98),
    "matisse": (27, 101, 157),
    "crowshead": (28, 18, 8),
    "rangoon green": (28, 30, 19),
    "persian blue": (28, 57, 187),
    "everglade": (28, 64, 46),
    "elm": (28, 124, 125),
    "green pea": (29, 97, 66),
    "creole": (30, 15, 4),
    "karaka": (30, 22, 9),
    "el paso": (30, 23, 8),
    "cello": (30, 56, 91),
    "te papa green": (30, 67, 60),
    "dodger blue": (30, 144, 255),
    "eastern blue": (30, 154, 176),
    "night rider": (31, 18, 15),
    "java": (31, 194, 194),
    "jacksons purple": (32, 32, 141),
    "cloud burst": (32, 46, 84),
    "blue dianne": (32, 72, 82),
    "eternity": (33, 26, 14),
    "deep blue": (34, 8, 120),
    "forest green": (34, 139, 34),
    "mallard": (35, 52, 24),
    "violet": (36, 10, 64),
    "kilamanjaro": (36, 12, 2),
    "log cabin": (36, 42, 29),
    "black olive": (36, 46, 22),
    "green house": (36, 80, 15),
    "graphite": (37, 22, 7),
    "cannon black": (37, 23, 6),
    "port gore": (37, 31, 79),
    "shark": (37, 39, 44),
    "green kelp": (37, 49, 28),
    "curious blue": (37, 150, 209),
    "paua": (38, 3, 104),
    "paris m": (38, 5, 106),
    "wood bark": (38, 17, 5),
    "gondola": (38, 20, 20),
    "steel gray": (38, 35, 53),
    "ebony clay": (38, 40, 59),
    "bay of many": (39, 58, 129),
    "plantation": (39, 80, 75),
    "eucalyptus": (39, 138, 91),
    "oil": (40, 30, 21),
    "astronaut": (40, 58, 119),
    "mariner": (40, 106, 205),
    "violent violet": (41, 12, 94),
    "bastille": (41, 33, 48),
    "zeus": (41, 35, 25),
    "charade": (41, 41, 55),
    "jelly bean": (41, 123, 154),
    "jungle green": (41, 171, 135),
    "cherry pie": (42, 3, 89),
    "coffee bean": (42, 20, 14),
    "baltic sea": (42, 38, 48),
    "turtle green": (42, 56, 11),
    "cerulean blue": (42, 82, 190),
    "sepia black": (43, 2, 2),
    "valhalla": (43, 25, 79),
    "heavy metal": (43, 50, 40),
    "blue gem": (44, 14, 140),
    "revolver": (44, 22, 50),
    "bleached cedar": (44, 33, 51),
    "lochinvar": (44, 140, 132),
    "mikado": (45, 37, 16),
    "outer space": (45, 56, 58),
    "st tropaz": (45, 86, 155),
    "jacaranda": (46, 3, 41),
    "jacko bean": (46, 25, 5),
    "rangitoto": (46, 50, 34),
    "rhino": (46, 63, 98),
    "sea green": (46, 139, 87),
    "scooter": (46, 191, 212),
    "onion": (47, 39, 14),
    "governor bay": (47, 60, 179),
    "sapphire": (47, 81, 158),
    "spectra": (47, 90, 87),
    "casal": (47, 97, 104),
    "melanzane": (48, 5, 41),
    "cocoa brown": (48, 31, 30),
    "woodrush": (48, 42, 15),
    "san juan": (48, 75, 106),
    "turquoise": (48, 213, 200),
    "eclipse": (49, 28, 23),
    "pickled bluewood": (49, 68, 89),
    "azure": (49, 91, 161),
    "calypso": (49, 114, 141),
    "paradiso": (49, 125, 130),
    "persian indigo": (50, 18, 122),
    "blackcurrant": (50, 41, 58),
    "mine shaft": (50, 50, 50),
    "stromboli": (50, 93, 82),
    "bilbao": (50, 124, 20),
    "astral": (50, 125, 160),
    "christalle": (51, 3, 107),
    "thunder": (51, 41, 47),
    "shamrock": (51, 204, 153),
    "tamarind": (52, 21, 21),
    "mardi gras": (53, 0, 54),
    "valentino": (53, 14, 66),
    "jagger": (53, 14, 87),
    "tuna": (53, 53, 66),
    "chambray": (53, 78, 140),
    "martinique": (54, 48, 80),
    "tuatara": (54, 53, 52),
    "waiouru": (54, 60, 13),
    "ming": (54, 116, 125),
    "la palma": (54, 135, 22),
    "chocolate": (55, 2, 2),
    "clinker": (55, 29, 9),
    "brown tumbleweed": (55, 41, 14),
    "birch": (55, 48, 33),
    "oracle": (55, 116, 117),
    "blue diamond": (56, 4, 116),
    "grape": (56, 26, 81),
    "dune": (56, 53, 51),
    "oxford blue": (56, 69, 85),
    "clover": (56, 73, 16),
    "limed spruce": (57, 72, 81),
    "dell": (57, 100, 19),
    "toledo": (58, 0, 32),
    "sambuca": (58, 32, 16),
    "jacarta": (58, 42, 106),
    "william": (58, 104, 108),
    "killarney": (58, 106, 71),
    "keppel": (58, 176, 158),
    "temptress": (59, 0, 11),
    "aubergine": (59, 9, 16),
    "jon": (59, 31, 31),
    "treehouse": (59, 40, 32),
    "amazon": (59, 122, 87),
    "boston blue": (59, 145, 180),
    "windsor": (60, 8, 120),
    "rebel": (60, 18, 6),
    "meteorite": (60, 31, 118),
    "dark ebony": (60, 32, 5),
    "camouflage": (60, 57, 16),
    "bright gray": (60, 65, 81),
    "cape cod": (60, 68, 67),
    "lunar green": (60, 73, 58),
    "bean  ": (61, 12, 2),
    "bistre": (61, 43, 31),
    "goblin": (61, 125, 82),
    "kingfisher daisy": (62, 4, 128),
    "cedar": (62, 28, 20),
    "english walnut": (62, 43, 35),
    "black marlin": (62, 44, 28),
    "ship gray": (62, 58, 68),
    "pelorous": (62, 171, 191),
    "bronze": (63, 33, 9),
    "cola": (63, 37, 0),
    "madras": (63, 48, 2),
    "minsk": (63, 48, 127),
    "cabbage pont": (63, 76, 58),
    "tom thumb": (63, 88, 59),
    "mineral green": (63, 93, 83),
    "puerto rico": (63, 193, 170),
    "harlequin": (63, 255, 0),
    "brown pod": (64, 24, 1),
    "cork": (64, 41, 29),
    "masala": (64, 59, 56),
    "thatch green": (64, 61, 25),
    "fiord": (64, 81, 105),
    "viridian": (64, 130, 109),
    "chateau green": (64, 168, 96),
    "ripe plum": (65, 0, 86),
    "paco": (65, 31, 16),
    "deep oak": (65, 32, 16),
    "merlin": (65, 60, 55),
    "gun powder": (65, 66, 87),
    "east bay": (65, 76, 125),
    "royal blue": (65, 105, 225),
    "ocean green": (65, 170, 120),
    "burnt maroon": (66, 3, 3),
    "lisbon brown": (66, 57, 33),
    "faded jade": (66, 121, 119),
    "scarlet gum": (67, 21, 96),
    "iroko": (67, 49, 32),
    "armadillo": (67, 62, 55),
    "river bed": (67, 76, 89),
    "green leaf": (67, 106, 13),
    "barossa": (68, 1, 45),
    "morocco brown": (68, 29, 0),
    "mako": (68, 73, 84),
    "kelp": (69, 73, 54),
    "san marino": (69, 108, 172),
    "picton blue": (69, 177, 232),
    "loulou": (70, 11, 65),
    "crater brown": (70, 36, 37),
    "gray asparagus": (70, 89, 69),
    "steel blue": (70, 130, 180),
    "rustic red": (72, 4, 4),
    "bulgarian rose": (72, 6, 7),
    "clairvoyant": (72, 6, 86),
    "cocoa bean": (72, 28, 28),
    "woody brown": (72, 49, 49),
    "taupe": (72, 60, 50),
    "van cleef": (73, 23, 12),
    "brown derby": (73, 38, 21),
    "metallic bronze": (73, 55, 27),
    "verdun green": (73, 84, 0),
    "blue bayoux": (73, 102, 121),
    "bismark": (73, 113, 131),
    "bracken": (74, 42, 4),
    "deep bronze": (74, 48, 4),
    "mondo": (74, 60, 48),
    "tundora": (74, 66, 68),
    "gravel": (74, 68, 75),
    "trout": (74, 78, 90),
    "pigment indigo": (75, 0, 130),
    "nandor": (75, 93, 82),
    "saddle": (76, 48, 36),
    "abbey": (76, 79, 86),
    "blackberry": (77, 1, 53),
    "cab sav": (77, 10, 24),
    "indian tan": (77, 30, 1),
    "cowboy": (77, 40, 45),
    "livid brown": (77, 40, 46),
    "rock": (77, 56, 51),
    "punga": (77, 61, 20),
    "bronzetone": (77, 64, 15),
    "woodland": (77, 83, 40),
    "mahogany": (78, 6, 6),
    "bossanova": (78, 42, 90),
    "matterhorn": (78, 59, 65),
    "bronze olive": (78, 66, 12),
    "mulled wine": (78, 69, 98),
    "axolotl": (78, 102, 73),
    "wedgewood": (78, 127, 158),
    "shakespeare": (78, 171, 209),
    "honey flower": (79, 28, 112),
    "daisy bush": (79, 35, 152),
    "indigo": (79, 105, 198),
    "fern green": (79, 121, 66),
    "fruit salad": (79, 157, 93),
    "apple": (79, 168, 61),
    "mortar": (80, 67, 81),
    "kashmir blue": (80, 112, 150),
    "cutty sark": (80, 118, 114),
    "emerald": (80, 200, 120),
    "emperor": (81, 70, 73),
    "chalet green": (81, 110, 61),
    "como": (81, 124, 102),
    "smalt blue": (81, 128, 143),
    "castro": (82, 0, 31),
    "maroon oak": (82, 12, 23),
    "gigas": (82, 60, 148),
    "voodoo": (83, 52, 85),
    "victoria": (83, 68, 145),
    "hippie green": (83, 130, 75),
    "heath": (84, 16, 18),
    "judge gray": (84, 67, 51),
    "fuscous gray": (84, 83, 77),
    "vida loca": (84, 144, 25),
    "cioccolato": (85, 40, 12),
    "saratoga": (85, 91, 16),
    "finlandia": (85, 109, 86),
    "havelock blue": (85, 144, 217),
    "fountain blue": (86, 180, 190),
    "spring leaves": (87, 131, 99),
    "saddle brown": (88, 52, 1),
    "scarpa flow": (88, 85, 98),
    "cactus": (88, 113, 86),
    "hippie blue": (88, 154, 175),
    "wine berry": (89, 29, 53),
    "brown bramble": (89, 40, 4),
    "congo brown": (89, 55, 55),
    "millbrook": (89, 68, 51),
    "waikawa gray": (90, 110, 156),
    "horizon": (90, 135, 160),
    "jambalaya": (91, 48, 19),
    "bordeaux": (92, 1, 32),
    "mulberry wood": (92, 5, 54),
    "carnaby tan": (92, 46, 1),
    "comet": (92, 93, 117),
    "redwood": (93, 30, 15),
    "don juan": (93, 76, 81),
    "chicago": (93, 92, 88),
    "verdigris": (93, 94, 55),
    "dingley": (93, 119, 71),
    "breaker bay": (93, 161, 159),
    "kabul": (94, 72, 62),
    "hemlock": (94, 93, 59),
    "irish coffee": (95, 61, 38),
    "mid gray": (95, 95, 110),
    "shuttle gray": (95, 102, 114),
    "aqua forest": (95, 167, 119),
    "tradewind": (95, 179, 172),
    "horses neck": (96, 73, 19),
    "smoky": (96, 91, 115),
    "corduroy": (96, 110, 104),
    "danube": (96, 147, 209),
    "espresso": (97, 39, 24),
    "eggplant": (97, 64, 81),
    "costa del sol": (97, 93, 48),
    "glade green": (97, 132, 95),
    "buccaneer": (98, 47, 48),
    "quincy": (98, 63, 45),
    "butterfly bush": (98, 78, 154),
    "west coast": (98, 81, 25),
    "finch": (98, 102, 73),
    "patina": (99, 154, 143),
    "fern": (99, 183, 108),
    "blue violet": (100, 86, 183),
    "dolphin": (100, 96, 119),
    "storm dust": (100, 100, 99),
    "siam": (100, 106, 84),
    "nevada": (100, 110, 117),
    "cornflower blue": (100, 149, 237),
    "viking": (100, 204, 219),
    "rosewood": (101, 0, 11),
    "cherrywood": (101, 26, 20),
    "purple heart": (101, 45, 193),
    "fern frond": (101, 114, 32),
    "willow grove": (101, 116, 93),
    "hoki": (101, 134, 159),
    "pompadour": (102, 0, 69),
    "purple": (102, 0, 153),
    "tyrian purple": (102, 2, 60),
    "dark tan": (102, 16, 16),
    "silver tree": (102, 181, 143),
    "bright green": (102, 255, 0),
    "screamin' green": (102, 255, 102),
    "black rose": (103, 3, 45),
    "scampi": (103, 95, 166),
    "ironside gray": (103, 102, 98),
    "viridian green": (103, 137, 117),
    "christi": (103, 167, 18),
    "nutmeg wood finish": (104, 54, 0),
    "zambezi": (104, 85, 88),
    "salt box": (104, 94, 110),
    "tawny port": (105, 37, 69),
    "finn": (105, 45, 84),
    "scorpion": (105, 95, 98),
    "lynch": (105, 126, 154),
    "spice": (106, 68, 46),
    "himalaya": (106, 93, 27),
    "soya bean": (106, 96, 81),
    "hairy heath": (107, 42, 20),
    "royal purple": (107, 63, 160),
    "shingle fawn": (107, 78, 49),
    "dorado": (107, 87, 85),
    "bermuda gray": (107, 139, 162),
    "olive drab": (107, 142, 35),
    "eminence": (108, 48, 130),
    "turquoise blue": (108, 218, 231),
    "lonestar": (109, 1, 1),
    "pine cone": (109, 94, 84),
    "dove gray": (109, 108, 108),
    "juniper": (109, 146, 146),
    "gothic": (109, 146, 161),
    "red oxide": (110, 9, 2),
    "moccaccino": (110, 29, 20),
    "pickled bean": (110, 72, 38),
    "dallas": (110, 75, 38),
    "kokoda": (110, 109, 87),
    "pale sky": (110, 119, 131),
    "cafe royale": (111, 68, 12),
    "flint": (111, 106, 97),
    "highland": (111, 142, 99),
    "limeade": (111, 157, 2),
    "downy": (111, 208, 197),
    "persian plum": (112, 28, 28),
    "sepia": (112, 66, 20),
    "antique bronze": (112, 74, 7),
    "ferra": (112, 79, 80),
    "coffee": (112, 101, 85),
    "slate gray": (112, 128, 144),
    "cedar wood finish": (113, 26, 0),
    "metallic copper": (113, 41, 29),
    "affair": (113, 70, 147),
    "studio": (113, 74, 178),
    "tobacco brown": (113, 93, 71),
    "yellow metal": (113, 99, 56),
    "peat": (113, 107, 86),
    "olivetone": (113, 110, 16),
    "storm gray": (113, 116, 134),
    "sirocco": (113, 128, 128),
    "aquamarine blue": (113, 217, 226),
    "venetian red": (114, 1, 15),
    "old copper": (114, 74, 47),
    "go ben": (114, 109, 78),
    "raven": (114, 123, 137),
    "seance": (115, 30, 143),
    "raw umber": (115, 74, 18),
    "kimberly": (115, 108, 159),
    "crocodile": (115, 109, 88),
    "crete": (115, 120, 41),
    "xanadu": (115, 134, 120),
    "spicy mustard": (116, 100, 13),
    "limed ash": (116, 125, 99),
    "rolling stone": (116, 125, 131),
    "blue smoke": (116, 136, 129),
    "laurel": (116, 147, 120),
    "mantis": (116, 195, 101),
    "russett": (117, 90, 87),
    "deluge": (117, 99, 168),
    "cosmic": (118, 57, 93),
    "blue marguerite": (118, 102, 198),
    "lima": (118, 189, 23),
    "sky blue": (118, 215, 234),
    "dark burgundy": (119, 15, 5),
    "crown of thorns": (119, 31, 31),
    "walnut": (119, 63, 26),
    "pablo": (119, 111, 97),
    "pacifika": (119, 129, 32),
    "oxley": (119, 158, 134),
    "pastel green": (119, 221, 119),
    "japanese maple": (120, 1, 9),
    "mocha": (120, 45, 25),
    "peanut": (120, 47, 22),
    "camouflage green": (120, 134, 107),
    "wasabi": (120, 138, 37),
    "ship cove": (120, 139, 186),
    "sea nymph": (120, 163, 156),
    "roman coffee": (121, 93, 76),
    "old lavender": (121, 104, 120),
    "rum": (121, 105, 137),
    "fedora": (121, 106, 120),
    "sandstone": (121, 109, 98),
    "spray": (121, 222, 236),
    "siren": (122, 1, 58),
    "fuchsia blue": (122, 88, 193),
    "boulder": (122, 122, 122),
    "wild blue yonder": (122, 137, 184),
    "de york": (122, 196, 136),
    "red beech": (123, 56, 1),
    "cinnamon": (123, 63, 0),
    "yukon gold": (123, 102, 8),
    "tapa": (123, 120, 116),
    "waterloo ": (123, 124, 148),
    "flax smoke": (123, 130, 101),
    "amulet": (123, 159, 128),
    "asparagus": (123, 160, 91),
    "kenyan copper": (124, 28, 5),
    "pesto": (124, 118, 49),
    "topaz": (124, 119, 138),
    "concord": (124, 123, 122),
    "jumbo": (124, 123, 130),
    "trendy green": (124, 136, 26),
    "gumbo": (124, 161, 166),
    "acapulco": (124, 176, 161),
    "neptune": (124, 183, 187),
    "pueblo": (125, 44, 20),
    "bay leaf": (125, 169, 141),
    "malibu": (125, 200, 247),
    "bermuda": (125, 216, 198),
    "copper canyon": (126, 58, 21),
    "claret": (127, 23, 52),
    "peru tan": (127, 58, 2),
    "falcon": (127, 98, 109),
    "mobster": (127, 117, 137),
    "moody blue": (127, 118, 211),
    "chartreuse": (127, 255, 0),
    "aquamarine": (127, 255, 212),
    "maroon": (128, 0, 0),
    "rose bud cherry": (128, 11, 71),
    "falu red": (128, 24, 24),
    "red robin": (128, 52, 31),
    "vivid violet": (128, 55, 144),
    "russet": (128, 70, 27),
    "friar gray": (128, 126, 121),
    "olive": (128, 128, 0),
    "gray": (128, 128, 128),
    "gulf stream": (128, 179, 174),
    "glacier": (128, 179, 196),
    "seagull": (128, 204, 234),
    "nutmeg": (129, 66, 44),
    "spicy pink": (129, 110, 113),
    "empress": (129, 115, 119),
    "spanish green": (129, 152, 133),
    "sand dune": (130, 111, 101),
    "gunsmoke": (130, 134, 133),
    "battleship gray": (130, 143, 114),
    "merlot": (131, 25, 35),
    "shadow": (131, 112, 80),
    "chelsea cucumber": (131, 170, 93),
    "monte carlo": (131, 208, 198),
    "plum": (132, 49, 121),
    "granny smith": (132, 160, 160),
    "chetwode blue": (133, 129, 217),
    "bandicoot": (133, 132, 112),
    "bali hai": (133, 159, 175),
    "half baked": (133, 196, 204),
    "red devil": (134, 1, 17),
    "lotus": (134, 60, 60),
    "ironstone": (134, 72, 60),
    "bull shot": (134, 77, 30),
    "rusty nail": (134, 86, 10),
    "bitter": (134, 137, 116),
    "regent gray": (134, 148, 159),
    "disco": (135, 21, 80),
    "americano": (135, 117, 110),
    "hurricane": (135, 124, 123),
    "oslo gray": (135, 141, 145),
    "sushi": (135, 171, 57),
    "spicy mix": (136, 83, 66),
    "kumera": (136, 98, 33),
    "suva gray": (136, 131, 135),
    "avocado": (136, 141, 101),
    "camelot": (137, 52, 86),
    "solid pink": (137, 56, 67),
    "cannon pink": (137, 67, 103),
    "makara": (137, 125, 109),
    "burnt umber": (138, 51, 36),
    "true v": (138, 115, 214),
    "clay creek": (138, 131, 96),
    "monsoon": (138, 131, 137),
    "stack": (138, 143, 138),
    "jordy blue": (138, 185, 241),
    "electric violet": (139, 0, 255),
    "monarch": (139, 7, 35),
    "corn harvest": (139, 107, 11),
    "olive haze": (139, 132, 112),
    "schooner": (139, 132, 126),
    "natural gray": (139, 134, 128),
    "mantle": (139, 156, 144),
    "portage": (139, 159, 238),
    "envy": (139, 166, 144),
    "cascade": (139, 169, 165),
    "riptide": (139, 230, 216),
    "cardinal pink": (140, 5, 94),
    "mule fawn": (140, 71, 47),
    "potters clay": (140, 87, 56),
    "trendy pink": (140, 100, 149),
    "paprika": (141, 2, 38),
    "sanguine brown": (141, 61, 56),
    "tosca": (141, 63, 63),
    "cement": (141, 118, 98),
    "granite green": (141, 137, 116),
    "manatee": (141, 144, 161),
    "polo blue": (141, 168, 204),
    "red berry": (142, 0, 0),
    "rope": (142, 77, 30),
    "opium": (142, 111, 112),
    "domino": (142, 119, 94),
    "mamba": (142, 129, 144),
    "nepal": (142, 171, 193),
    "pohutukawa": (143, 2, 28),
    "el salva": (143, 62, 51),
    "korma": (143, 75, 14),
    "squirrel": (143, 129, 118),
    "vista blue": (143, 214, 180),
    "burgundy": (144, 0, 32),
    "old brick": (144, 30, 30),
    "hemp": (144, 120, 116),
    "almond frost": (144, 123, 113),
    "sycamore": (144, 141, 57),
    "sangria": (146, 0, 10),
    "cumin": (146, 67, 33),
    "beaver": (146, 111, 91),
    "stonewall": (146, 133, 115),
    "venus": (146, 133, 144),
    "medium purple": (147, 112, 219),
    "cornflower": (147, 204, 234),
    "algae green": (147, 223, 184),
    "copper rust": (148, 71, 71),
    "arrowtown": (148, 135, 113),
    "scarlett": (149, 0, 21),
    "strikemaster": (149, 99, 135),
    "mountain mist": (149, 147, 150),
    "carmine": (150, 0, 24),
    "brown": (150, 75, 0),
    "leather": (150, 112, 89),
    "purple mountain's majesty": (150, 120, 182),
    "lavender purple": (150, 123, 182),
    "pewter": (150, 168, 161),
    "summer green": (150, 187, 171),
    "au chico": (151, 96, 93),
    "wisteria": (151, 113, 181),
    "atlantis": (151, 205, 45),
    "vin rouge": (152, 61, 97),
    "lilac bush": (152, 116, 211),
    "bazaar": (152, 119, 123),
    "hacienda": (152, 129, 27),
    "pale oyster": (152, 141, 119),
    "mint green": (152, 255, 152),
    "fresh eggplant": (153, 0, 102),
    "violet eggplant": (153, 17, 153),
    "tamarillo": (153, 22, 19),
    "totem pole": (153, 27, 7),
    "copper rose": (153, 102, 102),
    "amethyst": (153, 102, 204),
    "mountbatten pink": (153, 122, 141),
    "blue bell": (153, 153, 204),
    "prairie sand": (154, 56, 32),
    "toast": (154, 110, 97),
    "gurkha": (154, 149, 119),
    "olivine": (154, 185, 115),
    "shadow green": (154, 194, 184),
    "oregon": (155, 71, 3),
    "lemon grass": (155, 158, 143),
    "stiletto": (156, 51, 54),
    "hawaiian tan": (157, 86, 22),
    "gull gray": (157, 172, 183),
    "pistachio": (157, 194, 9),
    "granny smith apple": (157, 224, 147),
    "anakiwa": (157, 229, 255),
    "chelsea gem": (158, 83, 2),
    "sepia skin": (158, 91, 64),
    "sage": (158, 165, 135),
    "citron": (158, 169, 31),
    "rock blue": (158, 177, 205),
    "morning glory": (158, 222, 224),
    "cognac": (159, 56, 29),
    "reef gold": (159, 130, 28),
    "star dust": (159, 159, 156),
    "santas gray": (159, 160, 177),
    "sinbad": (159, 215, 211),
    "feijoa": (159, 221, 140),
    "tabasco": (160, 39, 18),
    "buttered rum": (161, 117, 13),
    "hit gray": (161, 173, 181),
    "citrus": (161, 197, 10),
    "aqua island": (161, 218, 215),
    "water leaf": (161, 233, 222),
    "flirt": (162, 0, 109),
    "rouge": (162, 59, 108),
    "cape palliser": (162, 102, 69),
    "gray chateau": (162, 170, 179),
    "edward": (162, 174, 171),
    "pharlap": (163, 128, 123),
    "amethyst smoke": (163, 151, 180),
    "blizzard blue": (163, 227, 237),
    "delta": (164, 164, 157),
    "wistful": (164, 166, 211),
    "green smoke": (164, 175, 110),
    "jazzberry jam": (165, 11, 94),
    "zorba": (165, 155, 145),
    "bahia": (165, 203, 12),
    "roof terracotta": (166, 47, 32),
    "paarl": (166, 85, 41),
    "barley corn": (166, 139, 91),
    "donkey brown": (166, 146, 121),
    "dawn": (166, 162, 154),
    "mexican red": (167, 37, 37),
    "luxor gold": (167, 136, 44),
    "rich gold": (168, 83, 7),
    "reno sand": (168, 101, 21),
    "coral tree": (168, 107, 107),
    "dusty gray": (168, 152, 155),
    "dull lavender": (168, 153, 230),
    "tallow": (168, 165, 137),
    "bud": (168, 174, 156),
    "locust": (168, 175, 142),
    "norway": (168, 189, 159),
    "chinook": (168, 227, 189),
    "gray olive": (169, 164, 145),
    "aluminium": (169, 172, 182),
    "cadet blue": (169, 178, 195),
    "schist": (169, 180, 151),
    "tower gray": (169, 189, 191),
    "perano": (169, 190, 242),
    "opal": (169, 198, 194),
    "night shadz": (170, 55, 90),
    "fire": (170, 66, 3),
    "muesli": (170, 139, 91),
    "sandal": (170, 141, 111),
    "shady lady": (170, 165, 169),
    "logan": (170, 169, 205),
    "spun pearl": (170, 171, 183),
    "regent st blue": (170, 214, 230),
    "magic mint": (170, 240, 209),
    "lipstick": (171, 5, 99),
    "royal heath": (171, 52, 114),
    "sandrift": (171, 145, 122),
    "cold purple": (171, 160, 217),
    "bronco": (171, 161, 150),
    "limed oak": (172, 138, 86),
    "east side": (172, 145, 206),
    "lemon ginger": (172, 158, 34),
    "napa": (172, 164, 148),
    "hillary": (172, 165, 134),
    "cloudy": (172, 165, 159),
    "silver chalice": (172, 172, 172),
    "swamp green": (172, 183, 142),
    "spring rain": (172, 203, 177),
    "conifer": (172, 221, 77),
    "celadon": (172, 225, 175),
    "mandalay": (173, 120, 27),
    "casper": (173, 190, 209),
    "moss green": (173, 223, 173),
    "padua": (173, 230, 196),
    "green yellow": (173, 255, 47),
    "hippie pink": (174, 69, 96),
    "desert": (174, 96, 32),
    "bouquet": (174, 128, 158),
    "medium carmine": (175, 64, 53),
    "apple blossom": (175, 77, 67),
    "brown rust": (175, 89, 62),
    "driftwood": (175, 135, 81),
    "alpine": (175, 143, 44),
    "lucky": (175, 159, 28),
    "martini": (175, 160, 158),
    "bombay": (175, 177, 184),
    "pigeon post": (175, 189, 217),
    "cadillac": (176, 76, 106),
    "matrix": (176, 93, 84),
    "tapestry": (176, 94, 129),
    "mai tai": (176, 102, 8),
    "del rio": (176, 154, 149),
    "powder blue": (176, 224, 230),
    "inch worm": (176, 227, 19),
    "bright red": (177, 0, 0),
    "vesuvius": (177, 74, 11),
    "pumpkin skin": (177, 97, 11),
    "santa fe": (177, 109, 82),
    "teak": (177, 148, 97),
    "fringy flower": (177, 226, 193),
    "ice cold": (177, 244, 231),
    "shiraz": (178, 9, 49),
    "biloba flower": (178, 161, 234),
    "tall poppy": (179, 45, 41),
    "fiery orange": (179, 82, 19),
    "hot toddy": (179, 128, 7),
    "taupe gray": (179, 175, 149),
    "la rioja": (179, 193, 16),
    "well read": (180, 51, 50),
    "blush": (180, 70, 104),
    "jungle mist": (180, 207, 211),
    "turkish rose": (181, 114, 129),
    "lavender": (181, 126, 220),
    "mongoose": (181, 162, 127),
    "olive green": (181, 179, 92),
    "jet stream": (181, 210, 206),
    "cruise": (181, 236, 223),
    "hibiscus": (182, 49, 108),
    "thatch": (182, 157, 152),
    "heathered gray": (182, 176, 149),
    "eagle": (182, 186, 164),
    "spindle": (182, 209, 234),
    "gum leaf": (182, 211, 191),
    "rust": (183, 65, 14),
    "muddy waters": (183, 142, 92),
    "sahara": (183, 162, 20),
    "husk": (183, 164, 88),
    "nobel": (183, 177, 177),
    "heather": (183, 195, 208),
    "madang": (183, 240, 190),
    "milano red": (184, 17, 4),
    "copper": (184, 115, 51),
    "gimblet": (184, 181, 106),
    "green spring": (184, 193, 177),
    "celery": (184, 194, 93),
    "sail": (184, 224, 249),
    "chestnut": (185, 78, 72),
    "crail": (185, 81, 64),
    "marigold": (185, 141, 40),
    "wild willow": (185, 196, 106),
    "rainee": (185, 200, 172),
    "guardsman red": (186, 1, 1),
    "rock spray": (186, 69, 12),
    "bourbon": (186, 111, 30),
    "pirate gold": (186, 127, 3),
    "nomad": (186, 177, 162),
    "submarine": (186, 199, 201),
    "charlotte": (186, 238, 249),
    "medium red violet": (187, 51, 133),
    "brandy rose": (187, 137, 131),
    "rio grande": (187, 208, 9),
    "surf": (187, 215, 193),
    "powder ash": (188, 201, 194),
    "tuscany": (189, 94, 46),
    "quicksand": (189, 151, 142),
    "silk": (189, 177, 168),
    "malta": (189, 178, 161),
    "chatelle": (189, 179, 199),
    "lavender gray": (189, 187, 215),
    "french gray": (189, 189, 198),
    "clay ash": (189, 200, 179),
    "loblolly": (189, 201, 206),
    "french pass": (189, 237, 253),
    "london hue": (190, 166, 195),
    "pink swan": (190, 181, 183),
    "fuego": (190, 222, 13),
    "rose of sharon": (191, 85, 0),
    "tide": (191, 184, 176),
    "blue haze": (191, 190, 216),
    "silver sand": (191, 193, 194),
    "key lime pie": (191, 201, 33),
    "ziggurat": (191, 219, 226),
    "lime": (191, 255, 0),
    "thunderbird": (192, 43, 24),
    "mojo": (192, 71, 55),
    "old rose": (192, 128, 129),
    "silver": (192, 192, 192),
    "pale leaf": (192, 211, 185),
    "pixie green": (192, 216, 182),
    "tia maria": (193, 68, 14),
    "fuchsia pink": (193, 84, 193),
    "buddha gold": (193, 160, 4),
    "bison hide": (193, 183, 164),
    "tea": (193, 186, 176),
    "gray suit": (193, 190, 205),
    "sprout": (193, 215, 176),
    "sulu": (193, 240, 124),
    "indochine": (194, 107, 3),
    "twine": (194, 149, 93),
    "cotton seed": (194, 189, 182),
    "pumice": (194, 202, 196),
    "jagged ice": (194, 232, 229),
    "maroon flush": (195, 33, 72),
    "indian khaki": (195, 176, 145),
    "pale slate": (195, 191, 193),
    "gray nickel": (195, 195, 189),
    "periwinkle gray": (195, 205, 230),
    "tiara": (195, 209, 209),
    "tropical blue": (195, 221, 249),
    "cardinal": (196, 30, 58),
    "fuzzy wuzzy brown": (196, 86, 85),
    "orange roughy": (196, 87, 25),
    "mist gray": (196, 196, 188),
    "coriander": (196, 208, 176),
    "mint tulip": (196, 244, 235),
    "mulberry": (197, 75, 140),
    "nugget": (197, 153, 34),
    "tussock": (197, 153, 75),
    "sea mist": (197, 219, 202),
    "yellow green": (197, 225, 122),
    "brick red": (198, 45, 66),
    "contessa": (198, 114, 107),
    "oriental pink": (198, 145, 145),
    "roti": (198, 168, 75),
    "ash": (198, 195, 181),
    "kangaroo": (198, 200, 189),
    "las palmas": (198, 230, 16),
    "monza": (199, 3, 30),
    "red violet": (199, 21, 133),
    "coral reef": (199, 188, 162),
    "melrose": (199, 193, 255),
    "cloud": (199, 196, 191),
    "ghost": (199, 201, 213),
    "pine glade": (199, 205, 144),
    "botticelli": (199, 221, 229),
    "antique brass": (200, 138, 101),
    "lilac": (200, 162, 200),
    "hokey pokey": (200, 165, 40),
    "lily": (200, 170, 191),
    "laser": (200, 181, 104),
    "edgewater": (200, 227, 215),
    "piper": (201, 99, 35),
    "pizza": (201, 148, 21),
    "light wisteria": (201, 160, 220),
    "rodeo dust": (201, 178, 155),
    "sundance": (201, 179, 91),
    "earls green": (201, 185, 59),
    "silver rust": (201, 192, 187),
    "conch": (201, 217, 210),
    "reef": (201, 255, 162),
    "aero blue": (201, 255, 229),
    "flush mahogany": (202, 52, 53),
    "turmeric": (202, 187, 72),
    "paris white": (202, 220, 212),
    "bitter lemon": (202, 224, 13),
    "skeptic": (202, 230, 218),
    "viola": (203, 143, 169),
    "foggy gray": (203, 202, 182),
    "green mist": (203, 211, 176),
    "nebula": (203, 219, 214),
    "persian red": (204, 51, 51),
    "burnt orange": (204, 85, 0),
    "ochre": (204, 119, 34),
    "puce": (204, 136, 153),
    "thistle green": (204, 202, 168),
    "periwinkle": (204, 204, 255),
    "electric lime": (204, 255, 0),
    "tenn": (205, 87, 0),
    "chestnut rose": (205, 92, 92),
    "brandy punch": (205, 132, 41),
    "onahau": (205, 244, 255),
    "sorrell brown": (206, 185, 143),
    "cold turkey": (206, 186, 186),
    "yuma": (206, 194, 145),
    "chino": (206, 199, 167),
    "eunry": (207, 163, 157),
    "old gold": (207, 181, 59),
    "tasman": (207, 220, 207),
    "surf crest": (207, 229, 210),
    "humming bird": (207, 249, 243),
    "scandal": (207, 250, 244),
    "red stage": (208, 95, 4),
    "hopbush": (208, 109, 161),
    "meteor": (208, 125, 18),
    "perfume": (208, 190, 248),
    "prelude": (208, 192, 229),
    "tea green": (208, 240, 192),
    "geebung": (209, 143, 27),
    "vanilla": (209, 190, 168),
    "soft amber": (209, 198, 180),
    "celeste": (209, 210, 202),
    "mischka": (209, 210, 221),
    "pear": (209, 226, 49),
    "hot cinnamon": (210, 105, 30),
    "raw sienna": (210, 125, 70),
    "careys pink": (210, 158, 170),
    "tan": (210, 180, 140),
    "deco": (210, 218, 151),
    "blue romance": (210, 246, 222),
    "gossip": (210, 248, 176),
    "sisal": (211, 203, 186),
    "swirl": (211, 205, 197),
    "charm": (212, 116, 148),
    "clam shell": (212, 182, 175),
    "straw": (212, 191, 141),
    "akaroa": (212, 196, 168),
    "bird flower": (212, 205, 22),
    "iron": (212, 215, 217),
    "geyser": (212, 223, 226),
    "hawkes blue": (212, 226, 252),
    "grenadier": (213, 70, 0),
    "can can": (213, 145, 164),
    "whiskey": (213, 154, 111),
    "winter hazel": (213, 209, 149),
    "granny apple": (213, 246, 227),
    "my pink": (214, 145, 136),
    "tacha": (214, 197, 98),
    "moon raker": (214, 206, 246),
    "quill gray": (214, 214, 209),
    "snowy mint": (214, 255, 219),
    "new york pink": (215, 131, 127),
    "pavlova": (215, 196, 152),
    "fog": (215, 208, 255),
    "valencia": (216, 68, 55),
    "japonica": (216, 124, 99),
    "thistle": (216, 191, 216),
    "maverick": (216, 194, 213),
    "foam": (216, 252, 250),
    "cabaret": (217, 73, 114),
    "burning sand": (217, 147, 118),
    "cameo": (217, 185, 155),
    "timberwolf": (217, 214, 207),
    "tana": (217, 220, 193),
    "link water": (217, 228, 245),
    "mabel": (217, 247, 255),
    "cerise": (218, 50, 135),
    "flame pea": (218, 91, 56),
    "bamboo": (218, 99, 4),
    "red damask": (218, 106, 65),
    "orchid": (218, 112, 214),
    "copperfield": (218, 138, 103),
    "golden grass": (218, 165, 32),
    "zanah": (218, 236, 214),
    "iceberg": (218, 244, 240),
    "oyster bay": (218, 250, 255),
    "cranberry": (219, 80, 121),
    "petite orchid": (219, 150, 144),
    "di serria": (219, 153, 94),
    "alto": (219, 219, 219),
    "frosted mint": (219, 255, 248),
    "crimson": (220, 20, 60),
    "punch": (220, 67, 51),
    "galliano": (220, 178, 12),
    "blossom": (220, 180, 188),
    "wattle": (220, 215, 71),
    "westar": (220, 217, 210),
    "moon mist": (220, 221, 204),
    "caper": (220, 237, 180),
    "swans down": (220, 240, 234),
    "swiss coffee": (221, 214, 213),
    "white ice": (221, 249, 241),
    "cerise red": (222, 49, 99),
    "roman": (222, 99, 96),
    "tumbleweed": (222, 166, 129),
    "gold tips": (222, 186, 19),
    "brandy": (222, 193, 150),
    "wafer": (222, 203, 198),
    "sapling": (222, 212, 164),
    "barberry": (222, 215, 23),
    "beryl green": (222, 229, 192),
    "pattens blue": (222, 245, 255),
    "heliotrope": (223, 115, 255),
    "apache": (223, 190, 111),
    "chenin": (223, 205, 111),
    "lola": (223, 207, 219),
    "willow brook": (223, 236, 218),
    "chartreuse yellow": (223, 255, 0),
    "mauve": (224, 176, 255),
    "anzac": (224, 182, 70),
    "harvest gold": (224, 185, 116),
    "calico": (224, 192, 149),
    "baby blue": (224, 255, 255),
    "sunglo": (225, 104, 101),
    "equator": (225, 188, 100),
    "pink flare": (225, 192, 200),
    "periglacial blue": (225, 230, 214),
    "kidnapper": (225, 234, 212),
    "tara": (225, 246, 232),
    "mandy": (226, 84, 101),
    "terracotta": (226, 114, 91),
    "golden bell": (226, 137, 19),
    "shocking": (226, 146, 192),
    "dixie": (226, 148, 24),
    "light orchid": (226, 156, 210),
    "snuff": (226, 216, 237),
    "mystic": (226, 235, 237),
    "apple green": (226, 243, 236),
    "razzmatazz": (227, 11, 92),
    "alizarin crimson": (227, 38, 54),
    "cinnabar": (227, 66, 52),
    "cavern pink": (227, 190, 190),
    "peppermint": (227, 245, 225),
    "mindaro": (227, 249, 136),
    "deep blush": (228, 118, 152),
    "gamboge": (228, 155, 15),
    "melanie": (228, 194, 213),
    "twilight": (228, 207, 222),
    "bone": (228, 209, 192),
    "sunflower": (228, 212, 34),
    "grain brown": (228, 213, 183),
    "zombie": (228, 214, 155),
    "frostee": (228, 246, 231),
    "snow flurry": (228, 255, 209),
    "amaranth": (229, 43, 80),
    "zest": (229, 132, 27),
    "dust storm": (229, 204, 201),
    "stark white": (229, 215, 189),
    "hampton": (229, 216, 175),
    "bon jour": (229, 224, 225),
    "mercury": (229, 229, 229),
    "polar": (229, 249, 246),
    "trinidad": (230, 78, 3),
    "gold sand": (230, 190, 138),
    "cashmere": (230, 190, 165),
    "double spanish white": (230, 215, 185),
    "satin linen": (230, 228, 212),
    "harp": (230, 242, 234),
    "off green": (230, 248, 243),
    "hint of green": (230, 255, 233),
    "tranquil": (230, 255, 255),
    "mango tango": (231, 114, 0),
    "christine": (231, 115, 10),
    "tonys pink": (231, 159, 140),
    "kobi": (231, 159, 196),
    "rose fog": (231, 188, 180),
    "corn": (231, 191, 5),
    "putty": (231, 205, 140),
    "gray nurse": (231, 236, 230),
    "lily white": (231, 248, 255),
    "bubbles": (231, 254, 255),
    "fire bush": (232, 153, 40),
    "shilo": (232, 185, 179),
    "pearl bush": (232, 224, 213),
    "green white": (232, 235, 224),
    "chrome white": (232, 241, 212),
    "gin": (232, 242, 235),
    "aqua squeeze": (232, 245, 242),
    "clementine": (233, 110, 0),
    "burnt sienna": (233, 116, 81),
    "tahiti gold": (233, 124, 7),
    "oyster pink": (233, 206, 205),
    "confetti": (233, 215, 90),
    "ebb": (233, 227, 227),
    "ottoman": (233, 248, 237),
    "clear day": (233, 255, 253),
    "carissma": (234, 136, 168),
    "porsche": (234, 174, 105),
    "tulip tree": (234, 179, 59),
    "rob roy": (234, 198, 116),
    "raffia": (234, 218, 184),
    "white rock": (234, 232, 212),
    "panache": (234, 246, 238),
    "solitude": (234, 246, 255),
    "aqua spring": (234, 249, 245),
    "dew": (234, 255, 254),
    "apricot": (235, 147, 115),
    "zinnwaldite": (235, 194, 175),
    "fuel yellow": (236, 169, 39),
    "ronchi": (236, 197, 78),
    "french lilac": (236, 199, 238),
    "just right": (236, 205, 185),
    "wild rice": (236, 224, 144),
    "fall green": (236, 235, 189),
    "aths special": (236, 235, 206),
    "starship": (236, 242, 69),
    "red ribbon": (237, 10, 63),
    "tango": (237, 122, 28),
    "carrot orange": (237, 145, 33),
    "sea pink": (237, 152, 158),
    "tacao": (237, 179, 129),
    "desert sand": (237, 201, 175),
    "pancho": (237, 205, 171),
    "chamois": (237, 220, 177),
    "primrose": (237, 234, 153),
    "frost": (237, 245, 221),
    "aqua haze": (237, 245, 245),
    "zumthor": (237, 246, 255),
    "narvik": (237, 249, 241),
    "honeysuckle": (237, 252, 132),
    "lavender magenta": (238, 130, 238),
    "beauty bush": (238, 193, 190),
    "chalky": (238, 215, 148),
    "almond": (238, 217, 196),
    "flax": (238, 220, 130),
    "bizarre": (238, 222, 218),
    "double colonial white": (238, 227, 173),
    "cararra": (238, 238, 232),
    "manz": (238, 239, 120),
    "tahuna sands": (238, 240, 200),
    "athens gray": (238, 240, 243),
    "tusk": (238, 243, 195),
    "loafer": (238, 244, 222),
    "catskill white": (238, 246, 247),
    "twilight blue": (238, 253, 255),
    "jonquil": (238, 255, 154),
    "rice flower": (238, 255, 226),
    "jaffa": (239, 134, 63),
    "gallery": (239, 239, 239),
    "porcelain": (239, 242, 243),
    "mauvelous": (240, 145, 169),
    "golden dream": (240, 213, 45),
    "golden sand": (240, 219, 125),
    "buff": (240, 220, 130),
    "prim": (240, 226, 236),
    "khaki": (240, 230, 140),
    "selago": (240, 238, 253),
    "titan white": (240, 238, 255),
    "alice blue": (240, 248, 255),
    "feta": (240, 252, 234),
    "gold drop": (241, 130, 0),
    "wewak": (241, 155, 171),
    "sahara sand": (241, 231, 136),
    "parchment": (241, 233, 210),
    "blue chalk": (241, 233, 255),
    "mint julep": (241, 238, 193),
    "seashell": (241, 241, 241),
    "saltpan": (241, 247, 242),
    "tidal": (241, 255, 173),
    "chiffon": (241, 255, 200),
    "flamingo": (242, 85, 42),
    "tangerine": (242, 133, 0),
    "mandys pink": (242, 195, 178),
    "concrete": (242, 242, 242),
    "black squeeze": (242, 250, 250),
    "pomegranate": (243, 71, 35),
    "buttercup": (243, 173, 22),
    "new orleans": (243, 214, 157),
    "vanilla ice": (243, 217, 223),
    "sidecar": (243, 231, 187),
    "dawn pink": (243, 233, 229),
    "wheatfield": (243, 237, 207),
    "canary": (243, 251, 98),
    "orinoco": (243, 251, 212),
    "carla": (243, 255, 216),
    "hollywood cerise": (244, 0, 161),
    "sandy brown": (244, 164, 96),
    "saffron": (244, 196, 48),
    "ripe lemon": (244, 216, 28),
    "janna": (244, 235, 211),
    "pampas": (244, 242, 238),
    "wild sand": (244, 244, 244),
    "zircon": (244, 248, 255),
    "froly": (245, 117, 132),
    "cream can": (245, 200, 92),
    "manhattan": (245, 201, 153),
    "maize": (245, 213, 160),
    "wheat": (245, 222, 179),
    "sandwisp": (245, 231, 162),
    "pot pourri": (245, 231, 226),
    "albescent white": (245, 233, 211),
    "soft peach": (245, 237, 239),
    "ecru white": (245, 243, 229),
    "beige": (245, 245, 220),
    "golden fizz": (245, 251, 61),
    "australian mint": (245, 255, 190),
    "french rose": (246, 74, 138),
    "brilliant rose": (246, 83, 166),
    "illusion": (246, 164, 201),
    "merino": (246, 240, 230),
    "black haze": (246, 247, 247),
    "spring sun": (246, 255, 220),
    "violet red": (247, 70, 138),
    "chilean fire": (247, 119, 3),
    "persian pink": (247, 127, 190),
    "rajah": (247, 182, 104),
    "azalea": (247, 200, 218),
    "we peep": (247, 219, 230),
    "quarter spanish white": (247, 242, 225),
    "whisper": (247, 245, 250),
    "snow drift": (247, 250, 247),
    "casablanca": (248, 184, 83),
    "chantilly": (248, 195, 223),
    "cherub": (248, 217, 233),
    "marzipan": (248, 219, 157),
    "energy yellow": (248, 221, 92),
    "givry": (248, 228, 191),
    "white linen": (248, 240, 232),
    "magnolia": (248, 244, 255),
    "spring wood": (248, 246, 241),
    "coconut cream": (248, 247, 220),
    "white lilac": (248, 247, 252),
    "desert storm": (248, 248, 247),
    "texas": (248, 249, 156),
    "corn field": (248, 250, 205),
    "mimosa": (248, 253, 211),
    "carnation": (249, 90, 97),
    "saffron mango": (249, 191, 88),
    "carousel pink": (249, 224, 237),
    "dairy cream": (249, 228, 188),
    "portica": (249, 230, 99),
    "amour": (249, 234, 243),
    "rum swizzle": (249, 248, 228),
    "dolly": (249, 255, 139),
    "sugar cane": (249, 255, 246),
    "ecstasy": (250, 120, 20),
    "tan hide": (250, 157, 90),
    "corvette": (250, 211, 162),
    "peach yellow": (250, 223, 173),
    "turbo": (250, 230, 0),
    "astra": (250, 234, 185),
    "champagne": (250, 236, 204),
    "linen": (250, 240, 230),
    "fantasy": (250, 243, 240),
    "citrine white": (250, 247, 214),
    "alabaster": (250, 250, 250),
    "hint of yellow": (250, 253, 228),
    "milan": (250, 255, 164),
    "brink pink": (251, 96, 127),
    "geraldine": (251, 137, 137),
    "lavender rose": (251, 160, 227),
    "sea buckthorn": (251, 161, 41),
    "sun": (251, 172, 19),
    "lavender pink": (251, 174, 210),
    "rose bud": (251, 178, 163),
    "cupid": (251, 190, 218),
    "classic rose": (251, 204, 231),
    "apricot peach": (251, 206, 177),
    "banana mania": (251, 231, 178),
    "marigold yellow": (251, 232, 112),
    "festival": (251, 233, 108),
    "sweet corn": (251, 234, 140),
    "candy corn": (251, 236, 93),
    "hint of red": (251, 249, 249),
    "shalimar": (251, 255, 186),
    "shocking pink": (252, 15, 192),
    "tickle me pink": (252, 128, 165),
    "tree poppy": (252, 156, 29),
    "lightning yellow": (252, 192, 30),
    "goldenrod": (252, 214, 103),
    "candlelight": (252, 217, 23),
    "cherokee": (252, 218, 152),
    "double pearl lusta": (252, 244, 208),
    "pearl lusta": (252, 244, 220),
    "vista white": (252, 248, 247),
    "bianca": (252, 251, 243),
    "moon glow": (252, 254, 218),
    "china ivory": (252, 255, 231),
    "ceramic": (252, 255, 249),
    "torch red": (253, 14, 53),
    "wild watermelon": (253, 91, 120),
    "crusta": (253, 123, 51),
    "sorbus": (253, 124, 7),
    "sweet pink": (253, 159, 162),
    "light apricot": (253, 213, 177),
    "pig pink": (253, 215, 228),
    "cinderella": (253, 225, 220),
    "golden glow": (253, 226, 149),
    "lemon": (253, 233, 16),
    "old lace": (253, 245, 230),
    "half colonial white": (253, 246, 211),
    "drover": (253, 247, 173),
    "pale prim": (253, 254, 184),
    "cumulus": (253, 255, 213),
    "persian rose": (254, 40, 162),
    "sunset orange": (254, 76, 64),
    "bittersweet": (254, 111, 94),
    "california": (254, 157, 4),
    "yellow sea": (254, 169, 4),
    "melon": (254, 186, 173),
    "bright sun": (254, 211, 60),
    "dandelion": (254, 216, 93),
    "salomie": (254, 219, 141),
    "cape honey": (254, 229, 172),
    "remy": (254, 235, 243),
    "oasis": (254, 239, 206),
    "bridesmaid": (254, 240, 236),
    "beeswax": (254, 242, 199),
    "bleach white": (254, 243, 216),
    "pipi": (254, 244, 204),
    "half spanish white": (254, 244, 219),
    "wisp pink": (254, 244, 248),
    "provincial pink": (254, 245, 241),
    "half dutch white": (254, 247, 222),
    "solitaire": (254, 248, 226),
    "white pointer": (254, 248, 255),
    "off yellow": (254, 249, 227),
    "orange white": (254, 252, 237),
    "red": (255, 0, 0),
    "rose": (255, 0, 127),
    "purple pizzazz": (255, 0, 204),
    "magenta": (255, 0, 255),
    "fuchsia": (255, 0, 255),
    "scarlet": (255, 36, 0),
    "wild strawberry": (255, 51, 153),
    "razzle dazzle rose": (255, 51, 204),
    "radical red": (255, 53, 94),
    "red orange": (255, 63, 52),
    "coral red": (255, 64, 64),
    "vermilion": (255, 77, 0),
    "international orange": (255, 79, 0),
    "outrageous orange": (255, 96, 55),
    "blaze orange": (255, 102, 0),
    "pink flamingo": (255, 102, 255),
    "orange": (255, 104, 31),
    "hot pink": (255, 105, 180),
    "persimmon": (255, 107, 83),
    "blush pink": (255, 111, 255),
    "burning orange": (255, 112, 52),
    "pumpkin": (255, 117, 24),
    "flamenco": (255, 125, 7),
    "flush orange": (255, 127, 0),
    "coral": (255, 127, 80),
    "salmon": (255, 140, 105),
    "pizazz": (255, 144, 0),
    "west side": (255, 145, 15),
    "pink salmon": (255, 145, 164),
    "neon carrot": (255, 153, 51),
    "atomic tangerine": (255, 153, 102),
    "vivid tangerine": (255, 153, 128),
    "sunshade": (255, 158, 44),
    "orange peel": (255, 160, 0),
    "mona lisa": (255, 161, 148),
    "web orange": (255, 165, 0),
    "carnation pink": (255, 166, 201),
    "hit pink": (255, 171, 129),
    "yellow orange": (255, 174, 66),
    "cornflower lilac": (255, 176, 172),
    "sundown": (255, 177, 179),
    "my sin": (255, 179, 31),
    "texas rose": (255, 181, 85),
    "cotton candy": (255, 183, 213),
    "macaroni and cheese": (255, 185, 123),
    "selective yellow": (255, 186, 0),
    "koromiko": (255, 189, 95),
    "amber": (255, 191, 0),
    "wax flower": (255, 192, 168),
    "pink": (255, 192, 203),
    "your pink": (255, 195, 192),
    "supernova": (255, 201, 1),
    "flesh": (255, 203, 164),
    "sunglow": (255, 204, 51),
    "golden tainoi": (255, 204, 92),
    "peach orange": (255, 204, 153),
    "chardonnay": (255, 205, 140),
    "pastel pink": (255, 209, 220),
    "romantic": (255, 210, 183),
    "grandis": (255, 211, 140),
    "gold": (255, 215, 0),
    "school bus yellow": (255, 216, 0),
    "cosmos": (255, 216, 217),
    "mustard": (255, 219, 88),
    "peach schnapps": (255, 220, 214),
    "caramel": (255, 221, 175),
    "tuft bush": (255, 221, 205),
    "watusi": (255, 221, 207),
    "pink lace": (255, 221, 244),
    "navajo white": (255, 222, 173),
    "frangipani": (255, 222, 179),
    "pippin": (255, 225, 223),
    "pale rose": (255, 225, 242),
    "negroni": (255, 226, 197),
    "cream brulee": (255, 229, 160),
    "peach": (255, 229, 180),
    "tequila": (255, 230, 199),
    "kournikova": (255, 231, 114),
    "sandy beach": (255, 234, 200),
    "karry": (255, 234, 212),
    "broom": (255, 236, 19),
    "colonial white": (255, 237, 188),
    "derby": (255, 238, 216),
    "vis vis": (255, 239, 161),
    "egg white": (255, 239, 193),
    "papaya whip": (255, 239, 213),
    "fair pink": (255, 239, 236),
    "peach cream": (255, 240, 219),
    "lavender blush": (255, 240, 245),
    "gorse": (255, 241, 79),
    "buttermilk": (255, 241, 181),
    "pink lady": (255, 241, 216),
    "forget me not": (255, 241, 238),
    "tutu": (255, 241, 249),
    "picasso": (255, 243, 157),
    "chardon": (255, 243, 241),
    "paris daisy": (255, 244, 110),
    "barley white": (255, 244, 206),
    "egg sour": (255, 244, 221),
    "sazerac": (255, 244, 224),
    "serenade": (255, 244, 232),
    "chablis": (255, 244, 243),
    "seashell peach": (255, 245, 238),
    "sauvignon": (255, 245, 243),
    "milk punch": (255, 246, 212),
    "varden": (255, 246, 223),
    "rose white": (255, 246, 245),
    "baja white": (255, 248, 209),
    "gin fizz": (255, 249, 226),
    "early dawn": (255, 249, 230),
    "lemon chiffon": (255, 250, 205),
    "bridal heath": (255, 250, 244),
    "scotch mist": (255, 251, 220),
    "soapstone": (255, 251, 249),
    "witch haze": (255, 252, 153),
    "buttery white": (255, 252, 234),
    "island spice": (255, 252, 238),
    "cream": (255, 253, 208),
    "chilean heath": (255, 253, 230),
    "travertine": (255, 253, 232),
    "orchid white": (255, 253, 243),
    "quarter pearl lusta": (255, 253, 244),
    "half and half": (255, 254, 225),
    "apricot white": (255, 254, 236),
    "rice cake": (255, 254, 240),
    "black white": (255, 254, 246),
    "romance": (255, 254, 253),
    "yellow": (255, 255, 0),
    "laser lemon": (255, 255, 102),
    "pale canary": (255, 255, 153),
    "portafino": (255, 255, 180),
    "ivory": (255, 255, 240),
    "white": (255, 255, 255),
}
